//
// Programmer:    Craig Stuart Sapp <craig@ccrma.stanford.edu>
// Creation Date: Sun Apr  5 13:07:18 PDT 1998
// Last Modified: Sun Apr  5 19:49:38 PDT 1998
// Last Modified: Fri Jan 15 07:24:00 PST 1999
// Last Modified: Sat Mar 27 18:17:59 PST 1999
// Filename:      ...sig/maint/code/base/Options.h
// Syntax:        C++ 
//


#ifndef _OPTIONS_H_INCLUDED
#define _OPTIONS_H_INCLUDED

#include "Array.h"

class option_list;
class option_register;


class Options {
   public:
                    Options             (void);
                    Options             (int argc, char** argv);
                   ~Options             ();

      int           argc                (void) const;
      char**        argv                (void) const;
      void          define              (const char* aDefinition);
      char*         getArg              (int index);
      char*         getArgument         (int index);
      int           getArgCount         (void);
      int           getArgumentCount    (void);
      int           getBoolean          (const char* optionName);
      const char*   getCommand          (void);
      const char*   getCommandLine      (void);
      const char*   getString           (void);
      const char*   getDefinition       (const char* optionName);
      double        getDouble           (const char* optionName);
      char          getFlag             (void);
      float         getFloat            (const char* optionName);
      int           getInt              (const char* optionName);
      int           getInteger          (const char* optionName);
      const char*   getString           (const char* optionName);
      char          getType             (const char* optionName);
      void          print               (void); 
      void          process             (int error_check = 1);
      void          process             (int argc, char** argv,
                                              int error_check = 1);
      void          reset               (void);
      void          verify              (int argc, char** argv, 
                                              int error_check = 1);
      void          verify              (int error_check = 1);
      void          setFlag             (char aFlag);
      void          setModified         (const char* optionName, 
                                           const char* optionValue);
      void          setOptions          (int argc, char** argv);


   protected:
      int                      options_error_check;  // for verify command
      int                      gargc;
      char**                   gargv;
      char*                    commandString;
      char                     optionFlag;
      Array<char*>             argument;
      Array<option_register*>  optionRegister;
      Array<option_list*>      optionList;
      int                      processedQ;
      int                      sortedQ;

      int          getRegIndex             (const char* optionName);
      int          optionQ                 (const char* aString, int& argp);
      void         sortOptionNames         (void);
      int          storeOption             (int gargp, int& position, 
                                                 int& running);

};

#define OPTION_BOOLEAN_TYPE   'b'
#define OPTION_CHAR_TYPE      'c'
#define OPTION_DOUBLE_TYPE    'd'
#define OPTION_FLOAT_TYPE     'f'
#define OPTION_INT_TYPE       'i'
#define OPTION_STRING_TYPE    's'
#define OPTION_UNKNOWN_TYPE   'x'


#endif  // _OPTIONS_H_INCLUDED



