//
// Programmer:    Craig Stuart Sapp <craig@ccrma.stanford.edu>
// Creation Date: Wed Feb  5 19:42:53 PST 1997
// Last Modified: Sun May 11 20:33:13 GMT-0800 1997
// Filename:      .../sig/code/base/Array/Array.h
// Syntax:        C++ 
// $Smake:        cc -Wall -g -c %b.cpp -I../../../include && rm -f %b.o
//

#ifndef _ARRAY_H_INCLUDED
#define _ARRAY_H_INCLUDED


#include "Collection.h"


template<class type>
class Array : public Collection<type> {
   public:
                     Array             (void);
                     Array             (int arraySize);
                     Array             (Array<type>& aArray);
                     Array             (int arraySize, type *anArray);
                    ~Array             ();

      void           setAll            (type aValue);
      type           sum               (void);
      type           sum               (int lowIndex, int hiIndex);
      void           zero              (int minIndex = -1, int maxIndex = -1);

      Array<type>&   operator=         (const Array<type>& aArray);
      Array<type>&   operator+=        (const Array<type>& aArray);
      Array<type>&   operator-=        (const Array<type>& aArray);
      Array<type>&   operator*=        (const Array<type>& aArray);
      Array<type>&   operator/=        (const Array<type>& aArray);

      Array<type>    operator+         (const Array<type>& aArray) const;
      Array<type>    operator+         (type aNumber) const;
      Array<type>    operator-         (const Array<type>& aArray) const;
      Array<type>    operator-         (void) const;

      Array<type>    operator-         (type aNumber) const;
      Array<type>    operator*         (const Array<type>& aArray) const;
      Array<type>    operator*         (type aNumber) const;
      Array<type>    operator/         (const Array<type>& aArray) const;
};


#include "Array.cpp"   /* necessary for templates */



#endif  // _ARRAY_H_INCLUDED



